/*
 * Decompiled with CFR 0.152.
 */
package azmalent.terraincognita.client.event;

import azmalent.terraincognita.TerraIncognita;
import azmalent.terraincognita.common.integration.ModIntegration;
import azmalent.terraincognita.common.inventory.BasketStackHandler;
import azmalent.terraincognita.common.item.block.BasketItem;
import azmalent.terraincognita.common.registry.ModBlocks;
import azmalent.terraincognita.common.registry.ModItems;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;

@OnlyIn(value=Dist.CLIENT)
public class TooltipHandler {
    private static final ResourceLocation SLOT_WIDGET = TerraIncognita.prefix("textures/gui/slot_widget.png");

    public static void registerListeners() {
        MinecraftForge.EVENT_BUS.addListener(TooltipHandler::removeDyedWreathTooltip);
        MinecraftForge.EVENT_BUS.addListener(TooltipHandler::renderBasketTooltip);
    }

    public static void removeDyedWreathTooltip(ItemTooltipEvent event) {
        if (event.getItemStack().func_77973_b() != ModItems.WREATH.get() || event.getFlags().func_194127_a()) {
            return;
        }
        List tooltip = event.getToolTip();
        for (ITextComponent line : tooltip) {
            String key;
            if (!(line instanceof TranslationTextComponent) || !(key = ((TranslationTextComponent)line).func_150268_i()).equals("item.dyed")) continue;
            tooltip.remove(line);
            return;
        }
    }

    public static void renderBasketTooltip(RenderTooltipEvent.PostText event) {
        int right;
        if (event.getStack().func_77973_b() != ModBlocks.BASKET.getItem()) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        MatrixStack matrix = event.getMatrixStack();
        MainWindow window = mc.func_228018_at_();
        BasketStackHandler stackHandler = BasketItem.getStackHandler(event.getStack());
        if (stackHandler.isEmpty()) {
            return;
        }
        int currentX = event.getX() - 5;
        int currentY = event.getY() - 70;
        int texWidth = 64;
        if (currentY < 0) {
            currentY = event.getY() + event.getLines().size() * 10 + 5;
        }
        if ((right = currentX + texWidth) > window.func_198107_o()) {
            currentX -= right - window.func_198107_o();
        }
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)0.0f, (float)0.0f, (float)700.0f);
        TooltipHandler.renderTooltipBackground(matrix, currentX, currentY);
        ItemRenderer render = mc.func_175599_af();
        for (int i = 0; i < 9; ++i) {
            ItemStack stack = stackHandler.getStackInSlot(i);
            int x = currentX + 6 + i % 3 * 18;
            int y = currentY + 6 + i / 3 * 18;
            if (!stack.func_190926_b()) {
                render.func_180450_b(stack, x, y);
                render.func_175030_a(mc.field_71466_p, stack, x, y);
            }
            if (ModIntegration.QUARK.matchesItemSearch(stack)) continue;
            RenderSystem.disableDepthTest();
            AbstractGui.func_238467_a_((MatrixStack)matrix, (int)x, (int)y, (int)(x + 16), (int)(y + 16), (int)-1442840576);
        }
        RenderSystem.popMatrix();
    }

    private static void renderTooltipBackground(MatrixStack matrix, int x, int y) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(SLOT_WIDGET);
        int CORNER = 5;
        boolean BUFFER = true;
        int EDGE = 18;
        AbstractGui.func_238463_a_((MatrixStack)matrix, (int)x, (int)y, (float)0.0f, (float)0.0f, (int)5, (int)5, (int)256, (int)256);
        AbstractGui.func_238463_a_((MatrixStack)matrix, (int)(x + 5 + 54), (int)(y + 5 + 54), (float)25.0f, (float)25.0f, (int)5, (int)5, (int)256, (int)256);
        AbstractGui.func_238463_a_((MatrixStack)matrix, (int)(x + 5 + 54), (int)y, (float)25.0f, (float)0.0f, (int)5, (int)5, (int)256, (int)256);
        AbstractGui.func_238463_a_((MatrixStack)matrix, (int)x, (int)(y + 5 + 54), (float)0.0f, (float)25.0f, (int)5, (int)5, (int)256, (int)256);
        for (int row = 0; row < 3; ++row) {
            AbstractGui.func_238463_a_((MatrixStack)matrix, (int)x, (int)(y + 5 + 18 * row), (float)0.0f, (float)6.0f, (int)5, (int)18, (int)256, (int)256);
            AbstractGui.func_238463_a_((MatrixStack)matrix, (int)(x + 5 + 54), (int)(y + 5 + 18 * row), (float)25.0f, (float)6.0f, (int)5, (int)18, (int)256, (int)256);
            for (int col = 0; col < 3; ++col) {
                if (row == 0) {
                    AbstractGui.func_238463_a_((MatrixStack)matrix, (int)(x + 5 + 18 * col), (int)y, (float)6.0f, (float)0.0f, (int)18, (int)5, (int)256, (int)256);
                    AbstractGui.func_238463_a_((MatrixStack)matrix, (int)(x + 5 + 18 * col), (int)(y + 5 + 54), (float)6.0f, (float)25.0f, (int)18, (int)5, (int)256, (int)256);
                }
                AbstractGui.func_238463_a_((MatrixStack)matrix, (int)(x + 5 + 18 * col), (int)(y + 5 + 18 * row), (float)6.0f, (float)6.0f, (int)18, (int)18, (int)256, (int)256);
            }
        }
        RenderSystem.color3f((float)1.0f, (float)1.0f, (float)1.0f);
    }
}

